/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.components;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.base.events.request.AssetUploadInfoRequestEvent;
import pro.gravit.launcher.base.request.cabinet.AssetUploadInfoRequest;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.utils.JavaFxUtils;
import pro.gravit.utils.helper.LogHelper;

public class UserBlock {
    private final JavaFXApplication application;
    private final Pane layout;
    private final AbstractScene.SceneAccessor sceneAccessor;
    private final ImageView avatar;
    private final Image originalAvatarImage;

    public UserBlock(Pane layout, AbstractScene.SceneAccessor sceneAccessor) {
        this.application = sceneAccessor.getApplication();
        this.layout = layout;
        this.sceneAccessor = sceneAccessor;
        this.avatar = (ImageView)LookupHelper.lookup((Node)layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)layout, "#avatar").ifPresent(h -> {
            try {
                JavaFxUtils.setStaticRadius(h, 8.0);
                h.setImage(this.originalAvatarImage);
            }
            catch (Throwable e) {
                LogHelper.warning((String)"Skin head error");
            }
        });
        this.reset();
    }

    public void reset() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(e -> e.setText(this.application.authService.getUsername()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#role").ifPresent(e -> e.setText(this.application.authService.getMainRole()));
        this.avatar.setImage(this.originalAvatarImage);
        this.resetAvatar();
        if (this.application.authService.isFeatureAvailable("assetupload")) {
            LookupHelper.lookupIfPossible((Node)this.layout, "#customization").ifPresent(h -> {
                h.setVisible(true);
                h.setOnAction(a -> this.sceneAccessor.processRequest(this.application.getTranslation("runtime.overlay.processing.text.uploadassetinfo"), new AssetUploadInfoRequest(), info -> this.sceneAccessor.runInFxThread(() -> this.sceneAccessor.showOverlay(this.application.gui.uploadAssetOverlay, (EventHandler<ActionEvent>)((EventHandler)f -> this.application.gui.uploadAssetOverlay.onAssetUploadInfo((AssetUploadInfoRequestEvent)info)))), this.sceneAccessor::errorHandle, (EventHandler<ActionEvent>)((EventHandler)e -> {})));
            });
        }
    }

    public void resetAvatar() {
        if (this.avatar == null) {
            return;
        }
        JavaFxUtils.putAvatarToImageView(this.application, this.application.authService.getUsername(), this.avatar);
    }
}

